﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="CustomerList.ascx.cs" Inherits="CustomerList" %>
<h4>
    Customer List</h4>
<asp:GridView ID="CustomerListGridView" runat="server" AutoGenerateColumns="False"
    Width="100%" BorderWidth="0px" CellPadding="2" CellSpacing="1" 
    DataSourceID="CustomerListDataSource"  DataKeyNames="Id"
    OnSelectedIndexChanged="CustomerListGridView_SelectedIndexChanged">
    <AlternatingRowStyle CssClass="Grid-Item-Alternate" />
    <RowStyle CssClass="Grid-Item" />
    <HeaderStyle CssClass="Grid-Header" />
    <SelectedRowStyle CssClass="Grid-Item-Selected" />
    <Columns>
        <asp:TemplateField HeaderStyle-HorizontalAlign="Left" HeaderText="Id">
            <ItemTemplate>
                <asp:LinkButton ID="btnSelect" Text='<%# Eval("Name")%>' runat="server" CommandName="Select" Visible="<%# !UsePopup %>"/>
                <asp:Hyperlink runat="server" NavigateUrl='<%# "javascript:var win=window.open(\"CustomerDetails.aspx?id=" + Eval("Id") + "\");" %>'
                               Text='<%# Eval("Name")%>'
                               Visible="<%# UsePopup %>"
                />
            </ItemTemplate>
        </asp:TemplateField>

        <asp:BoundField HeaderStyle-HorizontalAlign="Left" HeaderText="Address" DataField="Address"/>
        
    </Columns>
</asp:GridView>
<asp:ObjectDataSource ID="CustomerListDataSource" runat="server" DataObjectTypeName="Demo.DataModel.Customer"
    TypeName="CustomerPresentationModel" SelectMethod="GetCustomerList"
    OnObjectCreating="CustomerListDataSource_ObjectCreating" />
